/*
 * Decompiled with CFR 0.152.
 */
package net.adventurez.mixin;

import net.adventurez.access.EntityAccess;
import net.adventurez.init.ItemInit;
import net.adventurez.init.SoundInit;
import net.adventurez.init.TagInit;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={IronGolem.class})
public abstract class IronGolemEntityMixin
extends AbstractGolem
implements EntityAccess {
    private static final EntityDataAccessor<Boolean> BLACKSTONED = SynchedEntityData.m_135353_(IronGolem.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public IronGolemEntityMixin(EntityType<? extends AbstractGolem> entityType, Level world) {
        super(entityType, world);
    }

    @Inject(method={"initDataTracker"}, at={@At(value="TAIL")})
    protected void initDataTrackerMixin(CallbackInfo info) {
        this.f_19804_.m_135372_(BLACKSTONED, (Object)false);
    }

    @Inject(method={"writeCustomDataToNbt"}, at={@At(value="TAIL")})
    private void writeCustomDataToNbtMixin(CompoundTag nbt, CallbackInfo info) {
        nbt.m_128379_("Blackstoned", ((Boolean)this.f_19804_.m_135370_(BLACKSTONED)).booleanValue());
    }

    @Inject(method={"readCustomDataFromNbt"}, at={@At(value="TAIL")})
    private void readCustomDataFromNbtMixin(CompoundTag nbt, CallbackInfo info) {
        this.f_19804_.m_135381_(BLACKSTONED, (Object)nbt.m_128471_("Blackstoned"));
        if (nbt.m_128471_("Blackstoned")) {
            this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Creeper.class, false, true));
        }
    }

    @Inject(method={"interactMob"}, at={@At(value="INVOKE_ASSIGN", target="Lnet/minecraft/entity/player/PlayerEntity;getStackInHand(Lnet/minecraft/util/Hand;)Lnet/minecraft/item/ItemStack;")}, cancellable=true, locals=LocalCapture.CAPTURE_FAILSOFT)
    protected void interactMobMixin(Player player, InteractionHand hand, CallbackInfoReturnable<InteractionResult> info, ItemStack itemStack) {
        if (((Boolean)this.f_19804_.m_135370_(BLACKSTONED)).booleanValue()) {
            if (itemStack.m_41720_() instanceof BlockItem) {
                if (((BlockItem)itemStack.m_41720_()).m_40614_().m_49966_().m_204336_(TagInit.PLATFORM_NETHER_BLOCKS)) {
                    this.m_5634_(10.0f);
                    info.setReturnValue((Object)InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_()));
                }
            } else if (itemStack.m_150930_(ItemInit.GILDED_BLACKSTONE_SHARD)) {
                this.m_5634_(this.m_21233_() * 0.2f);
                info.setReturnValue((Object)InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_()));
            } else if (itemStack.m_150930_(ItemInit.BLACKSTONE_GOLEM_HEART)) {
                this.m_5634_(this.m_21233_());
                info.setReturnValue((Object)InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_()));
            }
        } else if (itemStack.m_150930_(ItemInit.BLACKSTONE_GOLEM_HEART)) {
            if (!this.m_9236_().m_5776_()) {
                this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Creeper.class, false, true));
                this.f_19804_.m_135381_(BLACKSTONED, (Object)true);
                this.m_21051_(Attributes.f_22276_).m_22100_(this.m_21172_(Attributes.f_22276_) + 100.0);
                this.m_21051_(Attributes.f_22281_).m_22100_(this.m_21172_(Attributes.f_22281_) + 5.0);
                this.m_21051_(Attributes.f_22279_).m_22100_(this.m_21172_(Attributes.f_22279_) + 0.04);
                this.m_21153_(this.m_21233_());
                itemStack.m_41774_(1);
            }
            this.m_9236_().m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundInit.GOLEM_AWAKENS_EVENT, SoundSource.NEUTRAL, 1.4f, 1.0f);
            info.setReturnValue((Object)InteractionResult.m_19078_((boolean)this.m_9236_().m_5776_()));
        }
    }

    @Inject(method={"canTarget"}, at={@At(value="HEAD")}, cancellable=true)
    private void canTargetMixin(EntityType<?> type, CallbackInfoReturnable<Boolean> info) {
        if (type == EntityType.f_20558_ && ((Boolean)this.f_19804_.m_135370_(BLACKSTONED)).booleanValue()) {
            info.setReturnValue((Object)true);
        }
    }

    @Override
    public EntityDataAccessor<Boolean> getTrackedDataBoolean() {
        return BLACKSTONED;
    }
}

